clear all; close all; clc;

% initialize dynare
dynare_config;

% load in estimation results
load NK_financial_results

%% Mode (requires finished first stage estimation)
% simulate the model at the estimated mode
get_posterior_parameters('mode',M_,estim_params_,oo_,options_);
options_.nofunctions = 1;
options_.nograph = 1;
options_.order = 2;
options_.pruning = 1;
options_.irf = 0;
var_list_=[];
info = stoch_simul(M_, options_, oo_, var_list_);

% data moments
load usdata_47q1_17q4_unscaled.mat
data1 = [mean(dyobs(75:282)) mean(dcobs(75:282)) mean(dinvobs(75:282)) mean(dwobs(75:282)) mean(robs(75:282)) mean(pinfobs(75:282)) mean(labobs(75:282)) mean(spreadobs(75:282))];
data2 = [std(dyobs(75:282)) std(dcobs(75:282)) std(dinvobs(75:282)) std(dwobs(75:282)) std(robs(75:282)) std(pinfobs(75:282)) std(labobs(75:282)) std(spreadobs(75:282))];
data3 = corr([(dyobs(75:282)) (dcobs(75:282)) (dinvobs(75:282)) (dwobs(75:282)) (robs(75:282)) (pinfobs(75:282)) (labobs(75:282)) (spreadobs(75:282))]);

% model implied moments
model1 = [oo_.mean(strmatch('dyobs',M_.endo_names,'exact')) oo_.mean(strmatch('dcobs',M_.endo_names,'exact')) oo_.mean(strmatch('dinvobs',M_.endo_names,'exact')) oo_.mean(strmatch('dwobs',M_.endo_names,'exact')) oo_.mean(strmatch('robs',M_.endo_names,'exact')) oo_.mean(strmatch('pinfobs',M_.endo_names,'exact')) oo_.mean(strmatch('labobs',M_.endo_names,'exact')) oo_.mean(strmatch('spreadobs',M_.endo_names,'exact'))];
model3 = oo_.var([strmatch('dyobs',M_.endo_names,'exact') strmatch('dcobs',M_.endo_names,'exact') strmatch('dinvobs',M_.endo_names,'exact') strmatch('dwobs',M_.endo_names,'exact') strmatch('robs',M_.endo_names,'exact') strmatch('pinfobs',M_.endo_names,'exact') strmatch('labobs',M_.endo_names,'exact') strmatch('spreadobs',M_.endo_names,'exact')],[strmatch('dyobs',M_.endo_names,'exact') strmatch('dcobs',M_.endo_names,'exact') strmatch('dinvobs',M_.endo_names,'exact') strmatch('dwobs',M_.endo_names,'exact') strmatch('robs',M_.endo_names,'exact') strmatch('pinfobs',M_.endo_names,'exact') strmatch('labobs',M_.endo_names,'exact') strmatch('spreadobs',M_.endo_names,'exact')]);
model2 = sqrt(diag(model3))';
model3 = model3./(model2'*model2);

%% Mean (requires finished second stage estimation)
% simulate the model at the estimated mode
get_posterior_parameters('mean',M_,estim_params_,oo_,options_);
options_.nofunctions = 1;
options_.nograph = 1;
options_.order = 2;
options_.pruning = 1;
options_.irf = 0;
var_list_=[];
info = stoch_simul(M_, options_, oo_, var_list_);

% model implied moments
model4 = [oo_.mean(strmatch('dyobs',M_.endo_names,'exact')) oo_.mean(strmatch('dcobs',M_.endo_names,'exact')) oo_.mean(strmatch('dinvobs',M_.endo_names,'exact')) oo_.mean(strmatch('dwobs',M_.endo_names,'exact')) oo_.mean(strmatch('robs',M_.endo_names,'exact')) oo_.mean(strmatch('pinfobs',M_.endo_names,'exact')) oo_.mean(strmatch('labobs',M_.endo_names,'exact')) oo_.mean(strmatch('spreadobs',M_.endo_names,'exact'))];
model6 = oo_.var([strmatch('dyobs',M_.endo_names,'exact') strmatch('dcobs',M_.endo_names,'exact') strmatch('dinvobs',M_.endo_names,'exact') strmatch('dwobs',M_.endo_names,'exact') strmatch('robs',M_.endo_names,'exact') strmatch('pinfobs',M_.endo_names,'exact') strmatch('labobs',M_.endo_names,'exact') strmatch('spreadobs',M_.endo_names,'exact')],[strmatch('dyobs',M_.endo_names,'exact') strmatch('dcobs',M_.endo_names,'exact') strmatch('dinvobs',M_.endo_names,'exact') strmatch('dwobs',M_.endo_names,'exact') strmatch('robs',M_.endo_names,'exact') strmatch('pinfobs',M_.endo_names,'exact') strmatch('labobs',M_.endo_names,'exact') strmatch('spreadobs',M_.endo_names,'exact')]);
model5 = sqrt(diag(model6))';
model6 = model6./(model5'*model5);

fprintf('First moments (x100)\n');
fprintf('      dyobs   dcobs   dinvobs dwobs   robs    pinfobs labobs\n')
fprintf('Data  ');
fprintf('%5.4f  ',100*data1);
fprintf('\nMode  ');
fprintf('%5.4f  ',100*model1);
fprintf('\nMean  ');
fprintf('%5.4f  ',100*model4);
fprintf('\n');
fprintf('Second moments (x100)\n');
fprintf('      dyobs   dcobs   dinvobs dwobs   robs    pinfobs labobs\n')
fprintf('Data  ');
fprintf('%5.4f  ',100*data2);
fprintf('\nMode  ');
fprintf('%5.4f  ',100*model2);
fprintf('\nMean  ');
fprintf('%5.4f  ',100*model5);
fprintf('\n');
fprintf('Correlation with dyobs\n');
fprintf('      dyobs   dcobs   dinvobs dwobs   robs    pinfobs labobs\n')
fprintf('Data  ');
fprintf('%5.4f  ',data3(1,:));
fprintf('\nMode  ');
fprintf('%5.4f  ',model3(1,:));
fprintf('\nMean  ');
fprintf('%5.4f  ',model6(1,:));
fprintf('\n');


